<?php
ini_set('display_errors', 1);

if(!extension_loaded('sqlite3')) {
    throw new Exception("sqlite3 拡張モジュールが有効になっていません。sqlite3拡張モジュールをインストールしてから再度試して下さい。");
}
if(!extension_loaded('mbstring')) {
    throw new Exception("mbstring 拡張モジュールが有効になっていません。mbstring拡張モジュールをインストールしてから再度試して下さい。");
    return false;
}


require_once('../lib/unicom.php');

try{
    $dbh = new PDO('sqlite::memory:');
}catch(exception $ex){
    echo($ex->getMessage());
    echo("<br>");
    echo("sqlite3拡張モジュールがインストールされていない可能性があります。<br>");
    echo("sqlite3拡張モジュールをインストールしてから再度試して下さい。<br>");
    return false;
}

$sqlite_version = $dbh->query('select sqlite_version()');
while ($row = $sqlite_version->fetch()){
  print "SQLite version: $row[0]" . PHP_EOL;
}
$dbh = null;
echo("<br>");
echo("PHP version: ".phpversion());
echo("<br>");


require_once('../admin/import_init_data.php');
$import_init_data = new import_inidata();

$pathinfo = pathinfo(__FILE__);
$basedirTmp = realpath($pathinfo['dirname'].'/..');
$basedir = $basedirTmp; 

$table_version = UVERSION;

if ($_SERVER["REQUEST_METHOD"] === "GET") {
	if(!empty($_GET["mode"])){
		if($_GET["mode"] == "upgrade"){
			$installmode = "upgrade";
		}elseif($_GET["mode"] == "new"){
			$installmode = "new";
		}else{
			$installmode = "new";
		}
	}
}else{
	$installmode = "new";
}

switch($installmode){
	case "upgrade":
		$drop_option = false;  //true: dropしない。
		break;
	case "new":
		$drop_option = true;  //true: drop・create tableする。
		break;
	default:
		echo("インストールの際にエラーが発生しました。");
		exit;
	break;
}

if(!isset($calname)){
    $calname = "";
}

?><html>
    <head>
        <link rel="stylesheet" type="text/css" href="../css/ucal_common.css"  media="all">
        <link rel="stylesheet" type="text/css" href="../css/ucalp.css" media="print">
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <link type="text/css" href="../js/jquery-ui-1.12.1.custom/jquery-ui.theme.min.css" rel="Stylesheet" />
        <script type="text/javascript" src="../js/jquery-3.2.1.min.js"></script>
        <script type="text/javascript" src="../js/jquery-ui-1.12.1.custom/jquery-ui.js"></script>
        <title><?php echo $calname; ?> Install</title>
</head>
<body>
<div id="pageimage">
<?php

//$db = new SQLite3("../data/unicale.db");

if (! $db = new PDO("sqlite:../data/unicale.db")) {
  die("DB Connection Failed.");
}
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

//$db->exec('begin');
//try {

    echo("カレンダーイベントテーブル作成");
    echo("<br>");

    if($drop_option){
        $db->exec(" DROP table IF EXISTS calendar;");
    }

    $sql = <<<SQL
CREATE TABLE IF NOT EXISTS calendar (
id              INTEGER PRIMARY KEY AUTOINCREMENT,
startdate		TEXT,
datemode		INTEGER,  --0orNULL: single date 1:multi date
vaguedate_f		INTEGER,
enddate			TEXT,
starttime		TEXT,    --10:30
endtime			TEXT,
starttime_zone	INTEGER,  --1:ALL1, 2:ALL2, 3:AM, 4:PM, 5:NONE
starttime_real  TEXT,
title			TEXT,
detail			TEXT,
member			TEXT,
place			TEXT,
category		INTEGER,
silent			INTEGER,
level			INTEGER,
usehour			INTEGER,
modified		TIMESTAMP DEFAULT (DATETIME('now','localtime')),
pickup          INTEGER,    --pickup欄に掲示する順番 
f_insert        BOOLEAN DEFAULT 1,
opt1			TEXT,
opt2			TEXT,
opt3			TEXT
)
SQL;
    $db->exec($sql);

if($installmode == "new"){
	$todayYYYYMMDD = date("Y-m-d");
	$sql = "";
	$sql .= "INSERT INTO calendar ( ";
	$sql .= "startdate, ";
	$sql .= "title, ";
	$sql .= "category, ";
	$sql .= "detail, ";
	$sql .= "starttime_zone, ";
	$sql .= "pickup ";
	$sql .= ") VALUES (";
	$sql .= "'".$todayYYYYMMDD."',";
	$sql .= "'カレンダーインストール',";
	$sql .= "1,";
	$sql .= "'この日にインストールをしました。', ";
	$sql .= "1, ";
	$sql .= "1 ";
	$sql .= ")";
	$db->exec($sql);

	$sql = "";
	$sql .= "INSERT INTO calendar ( ";
	$sql .= "startdate, ";
	$sql .= "title, ";
	$sql .= "category, ";
	$sql .= "detail, ";
	$sql .= "starttime_zone, ";
	$sql .= "pickup ";
	$sql .= ") VALUES (";
	$sql .= "'".$todayYYYYMMDD."',";
	$sql .= "'カテゴリごとに色を付けられます',";
	$sql .= "2,";
	$sql .= "'', ";
	$sql .= "1, ";
	$sql .= "1 ";
	$sql .= ")";
	$db->exec($sql);
}


    
echo("メンバーテーブル作成");
echo("<br>");
    if($drop_option){
        $db->exec("DROP table IF EXISTS member;");
    }
    $sql = <<<SQL
CREATE TABLE IF NOT EXISTS member (
id          INTEGER PRIMARY KEY AUTOINCREMENT,
dispid      INTEGER,
memname1    TEXT,
memname2	TEXT,
memname3	TEXT,
color       TEXT,
icon        TEXT,
f_small     INTEGER,
f_disp      INTEGER,
bikou       TEXT,
opt1        TEXT,
opt2        TEXT,
opt3        TEXT
)
SQL;
    $db->exec($sql);


	echo("カレンダーイベントとメンバー関連付けテーブル作成");
	echo("<br>");
    if($drop_option){
        $db->exec("DROP table IF EXISTS calendar_member;");
    }

    $sql = <<<SQL
CREATE TABLE IF NOT EXISTS calendar_member (
calendar_id          INTEGER,   -- same as calendar.id 
member_id            INTEGER,   -- same as member.id 
bikou                TEXT,
PRIMARY KEY(calendar_id,member_id)
)
SQL;
    $db->exec($sql);


echo("設定テーブル作成");
echo("<br>");

    if($drop_option){
        $db->exec("DROP table IF EXISTS conf;");
    }
    $sql = <<<SQL
CREATE TABLE IF NOT EXISTS conf (
calname             TEXT,
f_keiji_mode        BOOLEAN,
startyear           INTEGER,
endyear             INTEGER,
disp_category_flat     INTEGER,
monorsun            INTEGER,
monthnavistartmonth INTEGER,
event_calendar_mode INTEGER,
f_pickup_disp       BOOLEAN,
opt1                TEXT,
opt2                TEXT,
opt3                TEXT,
table_version		REAL
)
SQL;
$db->exec($sql);

if($installmode == "new"){
$sql = "";
$sql .= "INSERT INTO conf ( ";
$sql .= "calname, ";
$sql .= "f_keiji_mode, ";
$sql .= "monorsun, ";
$sql .= "monthnavistartmonth, ";
$sql .= "f_pickup_disp, ";
$sql .= "table_version ";
$sql .= ")VALUES( ";
$sql .= "'UNICALE3', ";
$sql .= "1, ";
$sql .= "0, ";
$sql .= "4, ";
$sql .= "1, ";
$sql .= " ".$table_version." ";
$sql .= ")";
$db->exec($sql);
}

if($installmode == "upgrade"){
	$sql  = "UPDATE conf SET ";
	$sql .= "table_version = ".$table_version." ";
	$db->exec($sql);
}


	echo("カレンダーイベントとメンバー名関連付けVIEW作成");
	echo("<br>");

	if($drop_option){
		$db->exec("DROP view IF EXISTS calendar_membername");
	}

if(ESC_IFNOTERR == 1){
	$sql = "CREATE VIEW ";
}else{
	$sql = "CREATE VIEW IF NOT EXISTS ";
}
$sql .= <<<SQL
calendar_membername AS 
SELECT 
    calendar_member.calendar_id AS id,
    member.id AS member_id,
    member.dispid,
    member.memname1,
    member.memname2,
    member.memname3,
    member.color,
    member.icon,
    member.f_small,
    member.f_disp,
    member.bikou 
FROM calendar_member 
LEFT OUTER JOIN member 
WHERE calendar_member.member_id = member.id;
SQL;
$db->exec($sql);

echo("メンバーテーブル作成");
echo("<br>");
if($drop_option){
	$db->exec("DROP table IF EXISTS member");
}

$sql = <<<SQL
CREATE TABLE IF NOT EXISTS member (
id                  INTEGER PRIMARY KEY,
dispid              INTEGER,    --表示順
memname1            TEXT,       --Full name
memname2            TEXT,       --Shortname about 2chars
memname3            TEXT,       --Shortname about 1chars
color               INTEGER,       --member Color Index number
icon                TEXT,       --not implement yet
f_small             INTEGER,    --0 or NULL: 縮小表示しない 1:縮小表示する
f_disp              INTEGER,    --0 or NULL: 表示しない 1:表示する
bikou               TEXT,       --
space               INTEGER,    --凡例表示の際にこのメンバーの後にスペースを何個入れるか
opt1                TEXT,
opt2                TEXT,
opt3                TEXT
)
SQL;
$db->exec($sql);

if($installmode == "new"){
	$sql = <<<SQL
INSERT INTO member (
id,
dispid,
memname1,
memname2,
memname3,
color,
icon,
f_small,
f_disp,
bikou,
space,
opt1,
opt2,
opt3
)VALUES(
1,
1,
'桃太郎',
'桃太',
'桃',
1,
0,
0,
1,
'初期設定(変更してください)',
0,
'',
'',
''
);

INSERT INTO member (
id,
dispid,
memname1,
memname2,
memname3,
color,
icon,
f_small,
f_disp,
bikou,
space,
opt1,
opt2,
opt3
)VALUES(
2,
2,
'浦島太郎',
'浦島',
'浦',
3,
0,
0,
1,
'初期設定(変更してください)',
0,
'',
'',
''
);

INSERT INTO member (
id,
dispid,
memname1,
memname2,
memname3,
color,
icon,
f_small,
f_disp,
bikou,
space,
opt1,
opt2,
opt3
)VALUES(
3,
3,
'金太郎',
'金太',
'金',
5,
0,
0,
1,
'初期設定(変更してください)',
0,
'',
'',
''
);

SQL;
    $db->exec($sql);
}


echo("メンバー色テーブル作成");
echo("<br>");
    if($drop_option){
        $db->exec("DROP table IF EXISTS member_color;");
    }
    $sql = <<<SQL
CREATE TABLE IF NOT EXISTS member_color (
id              INTEGER PRIMARY KEY,
color           TEXT
)
SQL;
    $db->exec($sql);


echo("カテゴリ色テーブル作成");
echo("<br>");
if($drop_option){
	$db->exec("DROP table IF EXISTS category_color;");
}

$sql = <<<SQL
CREATE TABLE IF NOT EXISTS category_color (
id              INTEGER PRIMARY KEY,
color           TEXT
)
SQL;
$db->exec($sql);


echo("カテゴリテーブル作成");
echo("<br>");
if($drop_option){
	$db->exec("DROP table IF EXISTS category;");
}
$sql = <<<SQL
CREATE TABLE IF NOT EXISTS category (
id              INTEGER PRIMARY KEY,
dispid          INTEGER,
categoryname    TEXT,
color           TEXT,
f_calc          BOOLEAN,
f_disp          BOOLEAN
)
SQL;
$db->exec($sql);

if($installmode == "new"){
	$sql = <<<SQL
INSERT INTO  category (
id,
dispid,
categoryname,
color,
f_calc,
f_disp
) VALUES (
1,
1,
'カテゴリ1',
1,
0,
1
)
SQL;
$db->exec($sql);
    
$sql = <<<SQL
INSERT INTO  category (
id,
dispid,
categoryname,
color,
f_calc,
f_disp
) VALUES (
2,
2,
'カテゴリ2',
3,
0,
1
)
SQL;
$db->exec($sql);
}
	
echo("時刻変換テーブル作成");
echo("<br>");
if($drop_option){
	$db->exec("DROP table IF EXISTS timecvt");    
}
$sql = <<<SQL
CREATE TABLE IF NOT EXISTS timecvt (
id                  INTEGER PRIMARY KEY,
timename            TEXT,               --ALL1, ALL2, AM, PM
timename_jp         TEXT,               --未定, 終日, 午前, 午後
convert_time        TEXT                --08:30,08:30,08:30, 13:00
)
SQL;
$db->exec($sql);

if($installmode == "new"){
$sql = <<<SQL
INSERT INTO timecvt (
id,
timename,
timename_jp,
convert_time
)VALUES(
1,'ALL1','未定','08:30'
);

INSERT INTO timecvt (
id,
timename,
timename_jp,
convert_time
)VALUES(
2,'ALL2','終日','08:30'
);

INSERT INTO timecvt (
id,
timename,
timename_jp,
convert_time
)VALUES(
3,'AM','午前','08:30'
);

INSERT INTO timecvt (
id,
timename,
timename_jp,
convert_time
)VALUES(
4,'PM','午後','13:00'
);
SQL;
	$db->exec($sql);
}

echo("ジャーナルビューの作成");
echo("<br>");
if($drop_option){
	$db->exec("DROP view IF EXISTS calendar_journal"); 
}
//ジャーナルビューの作成
if(ESC_IFNOTERR == 1){
	$sql = "CREATE VIEW ";
}else{
	$sql = "CREATE VIEW IF NOT EXISTS ";
}
$sql .= <<<SQL
 calendar_journal AS 
SELECT MAX(calendar.id) AS calendar_id,
calendar.modified,
calendar.title,
calendar.startdate,
calendar. starttime, 
calendar.endtime,
calendar.place,
calendar.f_insert,
group_concat(member.memname2," ") AS members,
IFNULL(timename_jp,starttime) AS starttime2 
 FROM ((calendar LEFT OUTER JOIN calendar_member ON calendar.id = calendar_member.calendar_id) 
 LEFT OUTER  JOIN member ON calendar_member.member_id = member.id) 
LEFT OUTER JOIN timecvt ON calendar.starttime = timecvt.timename 
GROUP BY calendar.id 
ORDER BY modified desc,member.dispid
SQL;
$db->exec($sql);


echo("エクスポートビューの作成");
echo("<br>");
//エクスポートビューの作成
$sql = "DROP VIEW IF EXISTS calendar_export";
$db->exec($sql);

if(ESC_IFNOTERR == 1){
	$sql = "CREATE VIEW ";
}else{
	$sql = "CREATE VIEW IF NOT EXISTS ";
}
$sql .= <<<SQL
 calendar_export AS
SELECT
calendar.id,
calendar.startdate,
calendar.datemode,
calendar.vaguedate_f,
calendar.enddate,
calendar.starttime,
calendar.endtime,
calendar.starttime_zone,
calendar.starttime_real,
calendar.title,
calendar.detail,
calendar.member,
calendar.place,
calendar.category,
calendar.silent,
calendar.level,
calendar.usehour,
calendar.modified,
calendar.pickup,
calendar.f_insert,
calendar.opt1,
calendar.opt2,
calendar.opt3,
group_concat(
    member.memname2,
    " "
) AS members,
IFNULL(
    timename_jp,
    starttime
) AS starttime2,
category.categoryname
FROM
    (
        (
            (
                calendar
                LEFT OUTER JOIN
                    calendar_member
                ON  calendar.id = calendar_member.calendar_id
            )
            LEFT OUTER JOIN
                member
            ON  calendar_member.member_id = member.id
        )
        LEFT OUTER JOIN
            timecvt
            ON  calendar.starttime = timecvt.timename
    ) LEFT outer JOIN
        category 
        ON calendar.category = category.id
    
GROUP BY
    calendar.id
ORDER BY
    calendar.id,
    member.dispid
SQL;
$db->exec($sql);




echo("タグテーブルの作成");
echo("<br>");
if($drop_option){
	$db->exec("DROP table IF EXISTS tag;");
}
//タグテーブルの作成
$sql = <<<SQL
CREATE TABLE IF NOT EXISTS tag (
tagname                 TEXT PRIMARY KEY
)
SQL;
$db->exec($sql);
	
//    $db->exec('commit');
//休日データテーブルの作成とデータの挿入
echo("祝日データのインポート");
$filepath = $basedir."/data/import/holiday.csv";
$tablename = "holiday";
$import_init_data->import_holiday($db,$filepath,$tablename);

if($installmode == "new"){
//固定休日データテーブルの作成とデータの挿入
    echo("<br>");
    echo("固定休日データのインポート");
    $tablename = "holiday_static";
    $filepath = $basedir."/data/import/holiday_static.csv";
    $import_init_data->import_holiday($db,$filepath,$tablename);

//年次固定イベントデータテーブルの作成とデータの挿入
    echo("<br>");
    echo("年次固定イベントデータのインポート");
    $tablename = "event_static";
    $filepath = $basedir."/data/import/event_static.csv";
    $import_init_data->import_event_static($db,$filepath,$tablename);

//メンバー色データテーブルの作成とデータの挿入
    echo("<br>");
    echo("メンバー色データのインポート");
    $filepath = $basedir."/data/import/member_color.csv";
    $tablename = "member_color";
    $import_init_data->import_color($db,$filepath,$tablename);

//カテゴリ色データテーブルの作成とデータの挿入
    echo("<br>");
    echo("カテゴリー色データのインポート");
    $filepath = $basedir."/data/import/category_color.csv";
    $tablename = "category_color";
    $import_init_data->import_color($db,$filepath,$tablename);
}
	
 
    
/*
} catch (Exception $e) {
    $db->exec("ROLLBACK;");
    echo $e->getTraceAsString();
    return;
}
*/
    


if($installmode == "new"){
	echo("TABLE作成とインストールが終了しました。");
}else{
	echo("アップグレードインストールが終了しました。");
}
echo("<br>");
echo("<br>");
echo("<a href='../index.php?mode=installed'>トップページへ</a>");

$msg = "TABLE作成が終了しました。";
//redirectJS($msg);
$db = null;
?>
    </div>
</body>
</html>


<?php
function redirectJS($msg){
    echo("<script language='Javascript'>");
    echo("alert('".$msg."');");
    echo("location.href = '../index.php';");
    echo("</script>");
}


?>