<?php
require_once('../lib/unicom.php');
require_once('../lib/unicomdisp.php');
require_once('../lib/uniview.php');

ini_set('display_errors', DISP_ERR);
ini_set('display_errors', 1);

if (! $db = new PDO("sqlite:../data/unicale.db")) {
  die("DB Connection Failed.");
}
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$unicom = new unicom();
$uniview = new uniview();
$redirect_url = '../index.php';
$redirect_f = false;
$confData = new confData();
$confData->getConfData($db);
$checkSubmit = new checkSubmit();
$rssProcess = new rssProcess();

$thisURL = (empty($_SERVER["HTTPS"]) ? "http://" : "https://") . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"];
$thisURLindex = (empty($_SERVER["HTTPS"]) ? "http://" : "https://") . $_SERVER["HTTP_HOST"] . $_SERVER["SCRIPT_NAME"];
$thisURLBase = str_replace("edit.php","",(empty($_SERVER["HTTPS"]) ? "http://" : "https://") . $_SERVER["HTTP_HOST"] . $_SERVER["SCRIPT_NAME"]);

$realtime_list = array();
$realtime_list = $unicom->cvtTimename2RealtimeList($db);

$calendar_output = "";

$dispWeekNum = 54;

$errMsg = "";
$err_f = 0;

$init_title = "";

$init_startdate = "";
$init_startyear = "";
$init_startmonth = "";
$init_startday = "";

$init_enddate = "";
$init_endyear = "";
$init_endmonth = "";
$init_endday = "";

$query_enddate = "";	//将来機能

$init_starttime = "";
$init_endtime = "";
$init_category = "";
$init_place = "";
$init_detail = "";
$init_silent = 0;
$init_pickup = 0;


$cptotomorrow_f = false;
$cptonextweek_f = false;
$cptonextmonth_f = false;
$cptonextyear_f = false;

$action_mode ="";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
	if (!empty($_POST["cptotomorrow"])){
		echo("tomorrow");
		$cptotomorrow_f = true;
	}
	if (!empty($_POST["cptonextweek"])){
		echo("nextweek");
		$cptonextweek_f = true;
	}

	if (!empty($_POST["cptonextmonth"])){
		echo("nextmonth");
		$cptonextmonth_f = true;
	}

	if (!empty($_POST["cptonextyear"])){
		echo("nextyear");
		$cptonextyear_f = true;
	}

	if (!empty($_POST["uni/year"]) && !empty($_POST["uni/month"]) && !empty($_POST["uni/month"]) && !empty($_POST["uni/title"])) {
		$action_mode = "insert";

		$post_year = sprintf('%04d', (int) htmlspecialchars($_POST["uni/year"]));
		$post_month = sprintf('%02d', (int) htmlspecialchars($_POST["uni/month"]));
		$post_day = sprintf('%02d', (int) htmlspecialchars($_POST["uni/day"]));

		if($cptotomorrow_f){
			$targetTime = mktime(0,0,0,$post_month, $post_day,$post_year);
			$post_year = sprintf('%04d', date('Y', strtotime('+1 day', $targetTime)));
			$post_month = sprintf('%02d', date('m', strtotime('+1 day', $targetTime)));
			$post_day = sprintf('%02d', date('d', strtotime('+1 day', $targetTime)));
		};

		if($cptonextweek_f){
			$targetTime = mktime(0,0,0,$post_month, $post_day,$post_year);
			$post_year = sprintf('%04d', date('Y', strtotime('+1 week', $targetTime)));
			$post_month = sprintf('%02d', date('m', strtotime('+1 week', $targetTime)));
			$post_day = sprintf('%02d', date('d', strtotime('+1 week', $targetTime)));
		};

		if($cptonextmonth_f){
			$targetTime = mktime(0,0,0,$post_month, $post_day,$post_year);
			$post_year = sprintf('%04d', date('Y', strtotime('+1 month', $targetTime)));
			$post_month = sprintf('%02d', date('m', strtotime('+1 month', $targetTime)));
			$post_day = sprintf('%02d', date('d', strtotime('+1 month', $targetTime)));
		};

		if($cptonextyear_f){
			$targetTime = mktime(0,0,0,$post_month, $post_day,$post_year);
			$post_year = sprintf('%04d', date('Y', strtotime('+1 year', $targetTime)));
			$post_month = sprintf('%02d', date('m', strtotime('+1 year', $targetTime)));
			$post_day = sprintf('%02d', date('d', strtotime('+1 year', $targetTime)));
		};

		$post_title = $checkSubmit->sanitize($_POST["uni/title"]);
		$query_startdate = $post_year."-".$post_month."-".$post_day;

	} else {
		$err_f = 1;
		$errMsg .= "入力されていない項目があります。";
	}
	if(empty($_POST["uni/title"])){
		$err_f = 1;
		$errMsg .= "用事タイトルが入力されていません。";
	}
	if (!empty($_POST["uni/place"])) {
		$post_place = $checkSubmit->sanitize($_POST["uni/place"]);
	}else{
		$post_place = "";
	}
	if (!empty($_POST["uni/category"])) {
		$post_category = (int) htmlspecialchars($_POST["uni/category"]);
	} else {
		$post_category = 0;
	}
	$vaguedate_f = 0;
	if (!empty($_POST["uni/starttime"])) {
		$post_starttime = $checkSubmit->sanitize($_POST["uni/starttime"]);
		switch ($post_starttime) {
			case "ALL1":
				$post_starttime_real = $realtime_list["ALL1"];
				$post_starttime_zone = 1;
				$vaguedate_f = 1;
				break;
			case "ALL2":
				$post_starttime_real = $realtime_list["ALL2"];
				$post_starttime_zone = 2;
				$vaguedate_f = 1;
				break;
			case "AM":
				$post_starttime_real = $realtime_list["AM"];
				$post_starttime_zone = 3;
				$vaguedate_f = 1;
				break;
			case "PM":
				$post_starttime_real = $realtime_list["PM"];
				$post_starttime_zone = 4;
				$vaguedate_f = 1;
				break;
			default:
				$post_starttime = sprintf("%04d",$post_starttime);
				$post_starttime_real = $post_starttime;
				$post_starttime_zone = 0;
				$vaguedate_f = 0;
		}
	}else{
		$post_starttime_real = "";
		$vaguedate_f = 0;
		$post_starttime_zone = 0;
	}
	if (!empty($_POST["uni/endtime"])) {
		$post_endtime = $checkSubmit->sanitize($_POST["uni/endtime"]);
	}else{
		$post_endtime ="";
	}
	if (!empty($_POST["uni/detail"])) {
		$post_detail = $checkSubmit->sanitize($_POST["uni/detail"]);
	}else{
		$post_detail = "";
	}

	$post_silent = 0;
	if (!empty($_POST["uni/silent"])) {
		$post_silent = (int) htmlspecialchars($_POST["uni/silent"]);
		if($post_silent != 1){
			$err_f = 1;
			$errMsg .= "何か変！";
		}else{
			$post_silent = 1;
		}
	}

	if (!empty($_POST["uni/member"])){
		$post_member = array();
		$chkmember_err_f = false;
		foreach($_POST["uni/member"] as $chkmember){
			if(!is_int((int)$chkmember)){
				$chkmember_err_f = true;
			}else{
				array_push($post_member, (int)$chkmember);
			}
		}

		if($chkmember_err_f){
			$err_f = 1;
			$errMsg .= "送信されたメンバーの値が不正です。";
		}
	}
	
	if (!empty($_POST["currentdate"])) {
		$post_currentdate = $checkSubmit->sanitize($_POST["currentdate"]);
		$err = '';
		$YYYY = (int) substr($post_currentdate,0,4);
		$MM = (int) substr($post_currentdate,4,2);
		$DD = (int) substr($post_currentdate,6,2);
		try {
			$targetDate = mktime(0, 0, 0, $MM, $DD, $YYYY);
		} catch (Exception $e) {
			echo ("日付指定に誤りがあります。");
			exit;
		}
		$post_currentdate = date("Ymd",mktime(0, 0, 0, $MM, $DD, $YYYY));

	}else{
		$post_currentdate = "";
	}

	if (!empty($_POST["uni/pickup"])) {
		$post_pickup = (int) htmlspecialchars($_POST["uni/pickup"]);
	}else{
		$post_pickup = 0;
	}
	
	if (!empty($_POST["uni/id"])) {
		$post_id = (int) htmlspecialchars($_POST["uni/id"]);
	}
	
	if (!empty($_POST["uni/chgtype"])){
		if($cptonextweek_f || $cptotomorrow_f || $cptonextmonth_f || $cptonextyear_f){
			$post_chgtype = "copy";
		}else{
			$post_chgtype = $checkSubmit->sanitize($_POST["uni/chgtype"]);
		}
	}else{
		$post_chgtype = "new";
	}
	if($err_f == 0){
		switch ($post_chgtype){
			case 'new':
				//カレンダーデータの追加
				$sql  = "INSERT INTO calendar( ";
				$sql .= "startdate,";
				$sql .= "datemode,";
				$sql .= "vaguedate_f,";
				$sql .= "enddate,";
				$sql .= "starttime,";
				$sql .= "endtime,";
				$sql .= "starttime_zone,";
				$sql .= "starttime_real,";
				$sql .= "title,";
				$sql .= "detail,";
				$sql .= "member,";
				$sql .= "place,";
				$sql .= "category,";
				$sql .= "silent,";
				$sql .= "level,";
				$sql .= "usehour,";
				$sql .= "pickup,";
				$sql .= "opt1,";
				$sql .= "opt2,";
				$sql .= "opt3";
				$sql .= ") VALUES (";
				$sql .= "'".$query_startdate."',";
				$sql .= "0,";  //datemode
				$sql .= $vaguedate_f.",";  //vaguedate_f
				$sql .= "'',"; //enddate
				$sql .= "'".$post_starttime."',"; //starttime
				$sql .= "'".$post_endtime."',"; //endtime
				$sql .= " ".$post_starttime_zone.","; 
				$sql .= "'".$post_starttime_real."',"; 
				$sql .= "'".$post_title."',"; //title
				$sql .= "'".$post_detail."',"; //detail
				$sql .= "'',"; //member
				$sql .= "'".$post_place."',"; //place
				$sql .= "".$post_category.",";  //category
				$sql .= $post_silent.",";  //silent
				$sql .= "0,";  //level
				$sql .= "0,";  //usehour
				$sql .= "".$post_pickup.",";  //pickup
				$sql .= "'',"; //opt1
				$sql .= "'',"; //opt2
				$sql .= "''	"; //opt3
				$sql .= ")";
				$db->exec('begin');
				try {
					$db->exec($sql);
					$db->exec('commit');
				} catch (Exception $e) {
					$db->exec("ROLLBACK;");
					echo $e->getTraceAsString();
					return;
				}

				$changed_startdate = $query_startdate;

				//INSERTしたカレンダーデータのIDを取得
				$sql  = "SELECT id FROM calendar WHERE ROWID = last_insert_rowid(); ";
				$inserted_id = 0;

				$db->exec('begin');
				try {
					$result_id = $db->query($sql);
					while( $inserted = $result_id->fetch() )  {
						$inserted_id = $inserted["id"];
					}
					$db->exec('commit');
				} catch (Exception $e) {
					$db->exec("ROLLBACK;");
					echo $e->getTraceAsString();
					return;
				}
				//メンバーカレンダーデータの追加
				if(isset($post_member)){
					foreach($post_member as $post_memberOne){
						$sql  = "INSERT INTO calendar_member( ";
						$sql .= "calendar_id,";
						$sql .= "member_id ";
						$sql .= ") VALUES (";
						$sql .= " ".$inserted_id.",";
						$sql .= " ".$post_memberOne." ";
						$sql .= ") ";
						try {
							$db->query($sql);
						} catch (Exception $e) {
							$db->exec("ROLLBACK;");
							echo $e->getTraceAsString();
							return;
						}
					}
				}
				
				//タグの追加
				$tags_array = $unicom->findtags($post_detail);
				foreach($tags_array[1] as $tagOne){
					$sql  = "INSERT OR REPLACE INTO tag( ";
					$sql .= "tagname ";
					$sql .= ") VALUES (";
					$sql .= " '".$tagOne."' ";
					$sql .= ") ";
					$db->query($sql);
				}

				$redirect_f = true;
				
				break;

			case 'change':
				$sql  = "UPDATE calendar SET ";
				$sql .= "startdate = '".$query_startdate."',";
				$sql .= "datemode = 1,";
				$sql .= "vaguedate_f = ".$vaguedate_f.",";
				$sql .= "enddate = '".$query_enddate."',";
				$sql .= "starttime= '".$post_starttime."',";
				$sql .= "endtime = '".$post_endtime."',";
				$sql .= "starttime_zone = ".$post_starttime_zone.",";
				$sql .= "starttime_real = '".$post_starttime_real."',";
				$sql .= "title = '".$post_title."',";
				$sql .= "detail = '".$post_detail."',";
				$sql .= "member = '',";
				$sql .= "place = '".$post_place."',";
				$sql .= "category = ".$post_category.",";
				$sql .= "silent = ".$post_silent.",";
				$sql .= "level = 0,";
				$sql .= "usehour = 0,";
				$sql .= "modified = datetime('now', 'localtime'), ";
				$sql .= "pickup = ".$post_pickup.",";
				$sql .= "f_insert = 0 ,";
				$sql .= "opt1 = '',";
				$sql .= "opt2 = '',";
				$sql .= "opt3 = '' ";
				$sql .= " WHERE ";
				$sql .= "id = ".$post_id;

				$db->exec('begin');
				try {
					$db->exec($sql);
					$db->exec('commit');

				} catch (Exception $e) {
					$db->exec("ROLLBACK;");
					echo $e->getTraceAsString();
					return;
				}
				$changed_startdate = $query_startdate;

				//メンバーカレンダーデータの追加
				//一旦削除
				$sql  = "DELETE FROM calendar_member ";
				$sql .= "WHERE ";
				$sql .= "calendar_id = ".$post_id;
				$db->exec($sql);

				//追加
				if(isset($post_member)){
					foreach($post_member as $post_memberOne){
						$sql  = "INSERT INTO calendar_member( ";
						$sql .= "calendar_id,";
						$sql .= "member_id ";
						$sql .= ") VALUES (";
						$sql .= " ".$post_id.",";
						$sql .= " ".$post_memberOne." ";
						$sql .= ") ";

						$db->exec('begin');
						try {
							$db->query($sql);
							$db->exec('commit');
						} catch (Exception $e) {
							$db->exec("ROLLBACK;");
							echo $e->getTraceAsString();
							return;
						}
					}
				}
				
				//タグの追加
				$tags_array = $unicom->findtags($post_detail);
				foreach($tags_array[1] as $tagOne){
					$sql  = "INSERT OR REPLACE INTO tag( ";
					$sql .= "tagname ";
					$sql .= ") VALUES (";
					$sql .= " '".$tagOne."' ";
					$sql .= ") ";
					$db->query($sql);
				}

				$redirect_f = true;
				break;

			case 'copy':
				$sql  = "INSERT INTO calendar( ";
				$sql .= "startdate,";
				$sql .= "datemode,";
				$sql .= "vaguedate_f,";
				$sql .= "enddate,";
				$sql .= "starttime,";
				$sql .= "endtime,";
				$sql .= "starttime_zone,";
				$sql .= "starttime_real,";
				$sql .= "title,";
				$sql .= "detail,";
				$sql .= "member,";
				$sql .= "place,";
				$sql .= "category,";
				$sql .= "silent,";
				$sql .= "level,";
				$sql .= "usehour,";
				$sql .= "pickup,";
				$sql .= "opt1,";
				$sql .= "opt2,";
				$sql .= "opt3";
				$sql .= ") VALUES (";
				$sql .= "'".$query_startdate."',";
				$sql .= "0,";  //datemode
				$sql .= $vaguedate_f.",";  //vaguedate_f
				$sql .= "'',"; //enddate
				$sql .= "'".$post_starttime."',"; //starttime
				$sql .= "'".$post_endtime."',"; //endtime
				$sql .= " ".$post_starttime_zone." ,";
				$sql .= "'".$post_starttime_real."',";
				$sql .= "'".$post_title."',"; //title
				$sql .= "'".$post_detail."',"; //detail
				$sql .= "'',"; //member
				$sql .= "'".$post_place."',"; //place
				$sql .= "".$post_category.",";  //category
				$sql .= $post_silent.",";  //silent
				$sql .= "0,";  //level
				$sql .= "0,";  //usehour
				$sql .= "".$post_pickup.",";  //pickup
				$sql .= "'".$post_id."',"; //opt1	コピー元calendar_id
				$sql .= "'',"; //opt2
				$sql .= "''	"; //opt3
				$sql .= ")";

				$db->exec('begin');
				try {
					$db->exec($sql);
					$db->exec('commit');
				} catch (Exception $e) {
					$db->exec("ROLLBACK;");
					echo $e->getTraceAsString();
					return;
				}
				$changed_startdate = $query_startdate;

				//INSERTしたカレンダーデータのIDを取得
				$sql  = "SELECT id FROM calendar WHERE ROWID = last_insert_rowid(); ";
				$inserted_id = 0;
				$db->exec('begin');
				try {
					$result_id = $db->query($sql);
					while( $inserted = $result_id->fetch() )  {
						$inserted_id = $inserted["id"];
					}
					$db->exec('commit');

				} catch (Exception $e) {
					$db->exec("ROLLBACK;");
					echo $e->getTraceAsString();
					return;
				}

				//メンバーカレンダーデータの追加
				if(isset($post_member)){
					foreach($post_member as $post_memberOne){
						$sql  = "INSERT INTO calendar_member( ";
						$sql .= "calendar_id,";
						$sql .= "member_id ";
						$sql .= ") VALUES (";
						$sql .= " ".$inserted_id.",";
						$sql .= " ".$post_memberOne." ";
						$sql .= ") ";

						try {
							$db->query($sql);
						} catch (Exception $e) {
							$db->exec("ROLLBACK;");
							echo $e->getTraceAsString();
							return;
						}
					}
				}
				
				//タグの追加
				$tags_array = $unicom->findtags($post_detail);
				foreach($tags_array[1] as $tagOne){
					$sql  = "INSERT OR REPLACE INTO tag( ";
					$sql .= "tagname ";
					$sql .= ") VALUES (";
					$sql .= " '".$tagOne."' ";
					$sql .= ") ";
					$db->query($sql);
				}

				$redirect_f = true;
				break;

			case 'delete':
				//戻り先のURLを削除した日付のところにするために，削除するIDの日付を取得する
				$sql  = "SELECT startdate FROM calendar ";
				$sql .= "WHERE ";
				$sql .= "id = ".$post_id;
				try {
					$result = $db->query($sql);
				} catch (Exception $e) {
					$db->exec("ROLLBACK;");
					echo $e->getTraceAsString();
					return;
				}
				while( $data = $result->fetch() )  {
					$changed_startdate = $data["startdate"];
				}

				$sql  = "DELETE FROM calendar ";
				$sql .= "WHERE ";
				$sql .= "id = ".$post_id;

				try {
					$db->query($sql);
				} catch (Exception $e) {
					$db->exec("ROLLBACK;");
					echo $e->getTraceAsString();
					return;
				}


				//カレンダーメンバーデータの削除
				$sql  = "DELETE FROM calendar_member ";
				$sql .= "WHERE ";
				$sql .= "calendar_id = ".$post_id;
				try {
					$db->query($sql);
				} catch (Exception $e) {
					$db->exec("ROLLBACK;");
					echo $e->getTraceAsString();
					return;
				}

				$redirect_f = true;
				break;

			default:
					$err_f = 1;
					$errMsg .= "何か変";
			break;
	}
	
	//RSS生成
	$title = $confData->conf["calname"];
	$thisScriptURL = $thisURLBase."index.php";
	$PublishDate = date(DATE_ATOM);
	$rssHeader = $rssProcess->rssHeader($title,$thisScriptURL,$PublishDate);
	$rssProcess->putRSS2($db,$thisURLBase,$rssHeader);
}

	   
}else{
	if ($_SERVER["REQUEST_METHOD"] === "GET") {
		if(!empty($_GET["n"])){ //カレンダーの日付をクリックされた入力の場合
			$get_date = $_GET["n"];
			$err = '';
			$YYYY = (int) substr($get_date,0,4);
			$MM = (int) substr($get_date,4,2);
			$DD = (int) substr($get_date,6,2);

			try {
				$targetDate = mktime(0, 0, 0, $MM, $DD, $YYYY);
			} catch (Exception $e) {
				echo ("日付指定に誤りがあります。");
				exit;
			}
			$targetDate = mktime(0, 0, 0, $MM, $DD, $YYYY);
		}else{
			$YYYY = "";
			$MM = "";
			$DD = "";
			$targetDate = time();
		}

		$init_startyear = date('Y', $targetDate);
		$init_startmonth = date('m', $targetDate);
		$init_startday = date('d', $targetDate);
		$YYYYMMDD = $YYYY.$MM.$DD;
		$post_calendar_id = "";

		if (!empty($_GET["id"])){
			$action_mode = "edit";
			$post_calendar_id = (int) htmlspecialchars($_GET["id"]);
			$sql  = "SELECT ";
		//	$sql .="	strftime('%Y/%m/%d',startdate) AS monthdate, ";
			$sql .= "datemode,";
			$sql .= "vaguedate_f, ";
			$sql .= "startdate, ";
			$sql .= "enddate, ";
			$sql .= "title, ";
			$sql .= "starttime, ";
			$sql .= "endtime, ";
			$sql .= "starttime_zone, ";
			$sql .= "detail, ";
			$sql .= "place, ";
			$sql .= "category, ";
			$sql .= "pickup, ";
			$sql .= "silent ";
			$sql .= "FROM calendar ";
			$sql .= "WHERE id =".$post_calendar_id." ";
			$counter = 0;
			try {
				$result = $db->query($sql);
			} catch (Exception $e) {
				$db->exec("ROLLBACK;");
				echo $e->getTraceAsString();
				return;
			}
			$calendar_data = "";

			while( $data = $result->fetch() )  {
				$init_title = $data["title"];
				$temp_startdate = explode("-",$data["startdate"]);
				$init_startyear = (int) $temp_startdate[0];
				$init_startmonth = (int) $temp_startdate[1];
				$init_startday = (int) $temp_startdate[2];

				$init_enddate = $data["enddate"];
				$init_starttime = $data["starttime"];
				$init_endtime = $data["endtime"];
				$init_place = $data["place"];
				$init_detail = $data["detail"];
				$init_category = $data["category"];
				$init_pickup = $data["pickup"];
				$init_silent = $data["silent"];

				//メンバーデータの取得
				$sql  = "SELECT ";
				$sql .= "memname1, ";
				$sql .= "memname2, ";
				$sql .= "memname3, ";
				$sql .= "color ";
				$sql .= "FROM calendar_membername ";
				$sql .= "WHERE id =".$post_calendar_id." ";
				$sql .= "ORDER BY dispid ";

				$member_result = $db->query($sql);

				$member_output = "aaa";
				while($member_data = $member_result->fetch()){
					$member_output .= "<span style='background-color:#".$member_data["color"]."'>".$member_data["memname3"]."</span>";
				}

				$one_calendar_data = $calendar_output.$member_output;

			}
		}else{
			$init_pickup = 2;
		}
	}
}

if(isset($changed_startdate)){
	$changed_startdate = str_replace("-","",$changed_startdate);
	$redirect_url = $redirect_url."?d=".$changed_startdate."&focus=".$changed_startdate;
}

ob_start();

$title = ($confData->conf["calname"])."カレンダー詳細";
if ($redirect_f == false){
	$redirect_url = "";
}
?>
	<a href="../index.php">
		<h1><?php echo($confData->conf["calname"]); ?></h1>
	</a>
<?php
if ($redirect_f == true){
	echo("<br><br>更新しました。<br>自動的にページ移動します。<br>移動しない場合はこちらをクリックしてください。<a href='".$redirect_url."'>トップページへ</a>");

	$uniview->setTitle($title);
	$uniview->setRedirect_url($redirect_url);
	$uniview->setRelativePath('../');
	$uniview->setContent(ob_get_clean());
	$uniview->showc();

	exit;
}
$currentYear = date("Y");
$currentMonth= date("m");
$currentDay  = date("d");
$currentlastDay = date('d', strtotime('last day of ' . $currentYear."-".$currentMonth));

if ($err_f != 0){
	echo("<script language='Javascript'>");
	echo("alert('".$errMsg."');");
	echo("location.href = '../index.php';");
	echo("</script>");
}
?>
	<form action="edit.php" method="post" name="form1">
		<div id="header1">
			<div class="text ui-widget-content ui-corner-all" style="padding: 10px;">
				<div class="inputbar1 ui-corner-all">
					<?php echo($unicom->makeYearListbox($init_startyear,$confData->conf["startyear"],$confData->conf["endyear"]));?>
					年
					<?php echo($unicom->makeMonthListbox($init_startmonth));?>
					月
					<?php echo($unicom->makeDayListbox($init_startday,""));?>
					日 &nbsp;&nbsp;
					用事
					<input type="text" name="uni/title" size="30" value="<?php echo(stripslashes($init_title)); ?>">&nbsp;&nbsp;
					場所
					<input type="text" name="uni/place" size="24" value="<?php echo(stripslashes($init_place)); ?>">&nbsp;&nbsp;
					<input type="submit" value="更新" class="button"><br>
					<div class="hanrei">
<?php
if ($action_mode == "edit"){
	echo("				<input type='radio' name='uni/chgtype' value='change' CHECKED>変更<input type='radio' name='uni/chgtype' value='copy'>複製<input type='radio' name='uni/chgtype' value='delete'>削除</span> ");
};
?>
					</div>
				</div>
				<div class="inputbar2 ui-corner-all">
					時刻
					<?php echo($unicom->makeStartTimeListbox($init_starttime,TIMESPAN));?>～
					<?php echo($unicom->makeEndTimeListbox($init_endtime,TIMESPAN));?>&nbsp;&nbsp;
					カテゴリ
					<?php echo($unicom->makeCategoryListbox($db,$init_category)); ?>&nbsp;&nbsp;
					ピックアップ表示
					<?php echo($unicom->makePickupListbox($init_pickup));?>&nbsp;&nbsp;
					<input type="checkbox" name="uni/silent" value="1" <?php if($init_silent==1 ){echo( "checked='CHECKD'");}; ?>> ひっそり
					<br>
					<div class="hanrei">
						<?php echo($unicom->makeMemberCheckBoxes2($db,$post_calendar_id));?>
					</div>
					詳細：
					<div class="hanrei">
						<textarea name="uni/detail" cols="80" rows="10"><?php echo(stripslashes($init_detail)); ?></textarea>
					</div>
					<div class="tags">
					<?php
					$alltags = $unicom->getTagsArray($db);
					if(count($alltags) > 0){
						foreach($alltags as $tagOne){
							echo("<a onClick=\"addTag('".$tagOne."')\">");
							echo("#".$tagOne);
							echo("</a>&nbsp;&nbsp;");
						}
					}

					?>
					</div>
				</div>
<?php		if ($action_mode == "edit"){ ?>
				<input type="submit" value="翌日にコピー" name="cptotomorrow">
				<input type="submit" value="翌週にコピー" name="cptonextweek">
				&nbsp;&nbsp;&nbsp;
				<input type="submit" value="翌月にコピー" name="cptonextmonth">
				<input type="submit" value="翌年にコピー" name="cptonextyear">
<?php		} ?>
			</div>

			</div>
		<input type="hidden" value="wrt" name="mode">
		<input type="hidden" name="uni/id" value="<?php if($action_mode == "edit"){echo($post_calendar_id);} ?>">
		<input type="hidden" name="currentdate" value="<?php //echo($_startyear.$init_startmonth.$init_startday); ?>">
	</form>
	<script>
	function addTag(param){
		Detailtxt = document.form1['uni/detail'].value + " #" + param;
		document.form1['uni/detail'].value = Detailtxt;
	}
	</script>
<?php
$db = null;
$unicom->dispCopyright($confData);
$unicom->dispRss();

$p = "../";

$uniview->setTitle($title);
$uniview->setRedirect_url($redirect_url);
$uniview->setRelativePath($p);
$uniview->setContent(ob_get_clean());

$uniview->showc();
?>
